/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.ConfigurableField;
import jace.core.Device;
import java.util.concurrent.locks.LockSupport;

public abstract class TimedDevice
extends Device {
    @ConfigurableField(name="Speed", description="(in hertz)")
    public long cyclesPerSecond = this.defaultCyclesPerSecond();
    @ConfigurableField(name="Max speed")
    public boolean maxspeed = false;
    private static final double NANOS_PER_SECOND = 1.0E9;
    private int cycleTimer = 0;
    private Thread worker;
    public static int TEMP_SPEED_MAX_DURATION = 1000000;
    private int tempSpeedDuration = 0;
    Thread timerThread;
    long nanosPerInterval;
    long cyclesPerInterval;
    long nextSync;
    long skip = 0L;
    long wait = 0L;

    public TimedDevice() {
        this.setSpeed(this.cyclesPerSecond);
    }

    @Override
    public abstract void tick();

    @Override
    public void suspend() {
        this.disableTempMaxSpeed();
        super.suspend();
        if (this.worker != null && this.worker.isAlive()) {
            try {
                this.worker.interrupt();
                this.worker.join(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.worker = null;
    }

    @Override
    public void resume() {
        if (this.isRunning()) {
            return;
        }
        super.resume();
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TimedDevice.this.isRunning()) {
                    TimedDevice.this.doTick();
                    TimedDevice.this.resync();
                }
            }
        });
        this.worker.setDaemon(false);
        this.worker.setPriority(6);
        this.worker.start();
        this.worker.setName(this.getDeviceName());
    }

    public final void setSpeed(long cyclesPerSecond) {
        this.cyclesPerInterval = cyclesPerSecond / 100L;
        this.nanosPerInterval = (long)((double)this.cyclesPerInterval * 1.0E9 / (double)cyclesPerSecond);
        this.cycleTimer = 0;
        this.resetSyncTimer();
    }

    public final void resetSyncTimer() {
        this.nextSync = System.nanoTime() + this.nanosPerInterval;
        this.cycleTimer = 0;
    }

    public void enableTempMaxSpeed() {
        this.tempSpeedDuration = TEMP_SPEED_MAX_DURATION;
    }

    public void disableTempMaxSpeed() {
        this.tempSpeedDuration = 0;
        this.resetSyncTimer();
    }

    protected void resync() {
        if ((long)(++this.cycleTimer) >= this.cyclesPerInterval) {
            if (this.maxspeed || this.tempSpeedDuration > 0) {
                if (this.tempSpeedDuration > 0) {
                    this.tempSpeedDuration = (int)((long)this.tempSpeedDuration - this.cyclesPerInterval);
                }
                this.resetSyncTimer();
                return;
            }
            long now = System.nanoTime();
            if (now < this.nextSync) {
                this.cycleTimer = 0;
                long currentSyncDiff = this.nextSync - now;
                if (currentSyncDiff > 2000000L) {
                    try {
                        Thread.sleep(currentSyncDiff / 1000000L, (int)(currentSyncDiff % 1000000L));
                    }
                    catch (InterruptedException ex) {
                        System.err.println(this.getDeviceName() + " was trying to sleep for " + currentSyncDiff / 1000000L + " millis but was woken up");
                    }
                } else {
                    LockSupport.parkNanos(currentSyncDiff);
                }
            }
            this.nextSync += this.nanosPerInterval;
        }
    }

    @Override
    public void reconfigure() {
        if (this.cyclesPerSecond == 0L) {
            this.cyclesPerSecond = this.defaultCyclesPerSecond();
        }
        this.setSpeed(this.cyclesPerSecond);
    }

    public abstract long defaultCyclesPerSecond();
}

